/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout;

import com.ldtteam.blockout.Alignment;
import com.ldtteam.blockout.PaneBuilders;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.Render;
import com.ldtteam.blockout.controls.AbstractTextBuilder;
import com.ldtteam.blockout.views.View;
import com.ldtteam.blockout.views.Window;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Pane
extends AbstractGui {
    @NotNull
    private static final Deque<ScissorsInfo> scissorsInfoStack = new ConcurrentLinkedDeque<ScissorsInfo>();
    protected static Pane lastClickedPane;
    protected static Pane focus;
    protected Pane onHover;
    protected static boolean debugging;
    protected Minecraft mc = Minecraft.func_71410_x();
    protected String id = "";
    protected int x = 0;
    protected int y = 0;
    protected int width = 0;
    protected int height = 0;
    protected Alignment alignment = Alignment.TOP_LEFT;
    protected boolean visible = true;
    protected boolean enabled = true;
    protected String onHoverId = "";
    protected Window window;
    protected View parent;
    protected boolean wasCursorInPane = false;
    private List<IFormattableTextComponent> toolTipLines = new ArrayList<IFormattableTextComponent>();

    public Pane() {
    }

    public Pane(@NotNull PaneParams params) {
        this.id = params.getString("id", this.id);
        params.getScaledInteger("size", params.getParentWidth(), params.getParentHeight(), a -> {
            this.width = (Integer)a.get(0);
            this.height = (Integer)a.get(1);
        });
        params.getScaledInteger("pos", params.getParentView().x, params.getParentView().y, a -> {
            this.x = (Integer)a.get(0);
            this.y = (Integer)a.get(1);
        });
        this.alignment = params.getEnum("align", Alignment.class, this.alignment);
        this.visible = params.getBoolean("visible", this.visible);
        this.enabled = params.getBoolean("enabled", this.enabled);
        this.onHoverId = params.getString("onHoverId", this.onHoverId);
        this.toolTipLines = params.getMultilineText("tooltip", this.toolTipLines);
    }

    public static synchronized Pane getFocus() {
        return focus;
    }

    public static void clearFocus() {
        Pane.setFocus(null);
    }

    public void onFocusLost() {
    }

    public void onFocus() {
    }

    public void parseChildren(PaneParams params) {
    }

    public final String getID() {
        return this.id;
    }

    public final void setID(String id) {
        this.id = id;
    }

    public void setSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void setPosition(int newX, int newY) {
        this.x = newX;
        this.y = newY;
    }

    public void moveBy(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    public void show() {
        this.setVisible(true);
    }

    public void hide() {
        this.setVisible(false);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void on() {
        this.setEnabled(true);
        this.setVisible(true);
    }

    public void off() {
        this.setEnabled(false);
        this.setVisible(false);
    }

    public final void setFocus() {
        Pane.setFocus(this);
    }

    public final synchronized boolean isFocus() {
        return focus == this;
    }

    public static synchronized void setFocus(Pane f) {
        if (focus != null) {
            focus.onFocusLost();
        }
        if ((focus = f) != null) {
            focus.onFocus();
        }
    }

    public void draw(MatrixStack ms, double mx, double my) {
        this.wasCursorInPane = this.isPointInPane(mx, my);
        this.handleHover();
        if (this.visible) {
            this.drawSelf(ms, mx, my);
            if (debugging) {
                int color = this.wasCursorInPane ? -16711936 : -16776961;
                Render.drawOutlineRect(ms, this.x, this.y, this.getWidth(), this.getHeight(), color);
                if (this.wasCursorInPane && !this.id.isEmpty()) {
                    int stringWidth = this.mc.field_71466_p.func_78256_a(this.id);
                    FontRenderer fontRenderer = this.mc.field_71466_p;
                    float f = this.x + this.getWidth() - stringWidth;
                    int n = this.y + this.getHeight();
                    this.mc.field_71466_p.getClass();
                    fontRenderer.func_238421_b_(ms, this.id, f, (float)(n - 9), color);
                }
            }
        }
    }

    public void drawLast(MatrixStack ms, double mx, double my) {
        if (this.visible) {
            this.drawSelfLast(ms, mx, my);
        }
    }

    public void drawSelf(MatrixStack ms, double mx, double my) {
    }

    public void drawSelfLast(MatrixStack ms, double mx, double my) {
    }

    public boolean isPointInPane(double mx, double my) {
        return this.isVisible() && mx >= (double)this.x && mx < (double)(this.x + this.width) && my >= (double)this.y && my < (double)(this.y + this.height);
    }

    public boolean wasCursorInPane() {
        return this.wasCursorInPane;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public final <T extends Pane> T findPaneOfTypeByID(String idIn, @NotNull Class<T> type) {
        Pane p = this.findPaneByID(idIn);
        try {
            return (T)((Object)((Pane)((Object)type.cast((Object)p))));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("No pane with id %s and type %s was found.", idIn, type), e);
        }
    }

    public final <T extends Pane> T findFirstPaneByType(@NotNull Class<T> type) {
        return this.findPaneByType(type);
    }

    @Nullable
    public Pane findPaneByID(String idIn) {
        return this.id.equals(idIn) ? this : null;
    }

    @Nullable
    public <T extends Pane> T findPaneByType(Class<T> type) {
        return (T)((Object)(((Object)((Object)this)).getClass().equals(type) ? (Pane)((Object)type.cast((Object)this)) : null));
    }

    public final View getParent() {
        return this.parent;
    }

    public final Window getWindow() {
        return this.window;
    }

    public void setWindow(Window w) {
        this.window = w;
        if (!this.toolTipLines.isEmpty()) {
            AbstractTextBuilder.TooltipBuilder ttBuilder = PaneBuilders.tooltipBuilder().hoverPane(this);
            this.toolTipLines.forEach(ttBuilder::appendNL);
            this.toolTipLines.clear();
            this.onHover = ttBuilder.build();
        }
        this.setHoverPane(this.onHover);
    }

    public void putInside(View newParent) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = newParent;
        if (this.parent != null) {
            this.parent.addChild(this);
            this.setSize(this.width, this.height);
        }
    }

    public boolean isClickable() {
        return this.visible && this.enabled;
    }

    public boolean click(double mx, double my) {
        Pane.setLastClickedPane(this);
        return this.handleClick(mx - (double)this.x, my - (double)this.y);
    }

    public boolean rightClick(double mx, double my) {
        Pane.setLastClickedPane(this);
        return this.handleRightClick(mx - (double)this.x, my - (double)this.y);
    }

    private static synchronized void setLastClickedPane(Pane pane) {
        lastClickedPane = pane;
    }

    public boolean handleClick(double mx, double my) {
        return false;
    }

    public boolean handleRightClick(double mx, double my) {
        return false;
    }

    public boolean canHandleClick(double mx, double my) {
        return this.visible && this.enabled && this.isPointInPane(mx, my);
    }

    public boolean onKeyTyped(char ch, int key) {
        return false;
    }

    public void onUpdate() {
    }

    protected synchronized void scissorsStart(MatrixStack ms, int contentWidth, int contentHeight) {
        int fbWidth = this.mc.field_195558_d.func_198109_k();
        int fbHeight = this.mc.field_195558_d.func_198091_l();
        Vector4f start = new Vector4f((float)this.x, (float)this.y, 0.0f, 1.0f);
        Vector4f end = new Vector4f((float)(this.x + this.width), (float)(this.y + this.height), 0.0f, 1.0f);
        start.func_229372_a_(ms.func_227866_c_().func_227870_a_());
        end.func_229372_a_(ms.func_227866_c_().func_227870_a_());
        int scissorsXstart = MathHelper.func_76125_a((int)((int)Math.floor(start.func_195910_a())), (int)0, (int)fbWidth);
        int scissorsXend = MathHelper.func_76125_a((int)((int)Math.floor(end.func_195910_a())), (int)0, (int)fbWidth);
        int scissorsYstart = MathHelper.func_76125_a((int)((int)Math.floor(start.func_195913_b())), (int)0, (int)fbHeight);
        int scissorsYend = MathHelper.func_76125_a((int)((int)Math.floor(end.func_195913_b())), (int)0, (int)fbHeight);
        int temp = scissorsYstart;
        scissorsYstart = fbHeight - scissorsYend;
        scissorsYend = fbHeight - temp;
        if (!scissorsInfoStack.isEmpty()) {
            ScissorsInfo parentInfo = scissorsInfoStack.peek();
            scissorsXstart = Math.max(scissorsXstart, parentInfo.xStart);
            scissorsXend = Math.max(scissorsXstart, Math.min(parentInfo.xEnd, scissorsXend));
            scissorsYstart = Math.max(scissorsYstart, parentInfo.yStart);
            scissorsYend = Math.max(scissorsYstart, Math.min(parentInfo.yEnd, scissorsYend));
        }
        ScissorsInfo info = new ScissorsInfo(scissorsXstart, scissorsXend, scissorsYstart, scissorsYend, this.window.getScreen().field_230708_k_, this.window.getScreen().field_230709_l_);
        scissorsInfoStack.push(info);
        this.window.getScreen().field_230708_k_ = contentWidth;
        this.window.getScreen().field_230709_l_ = contentHeight;
        RenderSystem.enableScissor((int)scissorsXstart, (int)scissorsYstart, (int)(scissorsXend - scissorsXstart), (int)(scissorsYend - scissorsYstart));
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    protected synchronized void scissorsEnd(MatrixStack ms) {
        ScissorsInfo popped = scissorsInfoStack.pop();
        if (debugging) {
            int color = -65536;
            int w = popped.xEnd - popped.xStart;
            int h = popped.yEnd - popped.yStart;
            int yStart = this.mc.field_195558_d.func_198091_l() - popped.yEnd;
            ms.func_227860_a_();
            ms.func_227866_c_().func_227870_a_().func_226591_a_();
            Render.drawOutlineRect(ms, popped.xStart, yStart, w, h, -65536, 2.0f);
            String scId = "scissor_" + (this.id.isEmpty() ? ((Object)((Object)this)).toString() : this.id);
            int scale = (int)this.mc.field_195558_d.func_198100_s();
            int stringWidth = this.mc.field_71466_p.func_78256_a(scId);
            ms.func_227862_a_((float)scale, (float)scale, 1.0f);
            FontRenderer fontRenderer = this.mc.field_71466_p;
            float f = (popped.xStart + w) / scale - stringWidth;
            int n = (yStart + h) / scale;
            this.mc.field_71466_p.getClass();
            fontRenderer.func_238421_b_(ms, scId, f, (float)(n - 9), -65536);
            ms.func_227865_b_();
        }
        this.window.getScreen().field_230708_k_ = popped.oldGuiWidth;
        this.window.getScreen().field_230709_l_ = popped.oldGuiHeight;
        if (!scissorsInfoStack.isEmpty()) {
            ScissorsInfo info = scissorsInfoStack.peek();
            RenderSystem.enableScissor((int)info.xStart, (int)info.yStart, (int)(info.xEnd - info.xStart), (int)(info.yEnd - info.yStart));
        } else {
            RenderSystem.disableScissor();
        }
    }

    public boolean scrollInput(double wheel, double mx, double my) {
        return false;
    }

    public void setParentView(View view) {
        this.parent = view;
    }

    protected void handleHover() {
        if (this.onHover == null && !this.onHoverId.isEmpty()) {
            this.onHover = this.window.findPaneByID(this.onHoverId);
            Objects.requireNonNull(this.onHover, String.format("Hover pane \"%s\" for \"%s\" was not found.", this.onHoverId, this.id));
        }
        if (this.onHover == null) {
            return;
        }
        if (this.wasCursorInPane && !this.onHover.isVisible() && this.onHover.isEnabled()) {
            this.onHover.show();
        } else if (!this.onHover.wasCursorInPane && !this.wasCursorInPane && this.onHover.isVisible()) {
            this.onHover.hide();
        }
    }

    public Pane setHoverPane(Pane hoverPane) {
        if (this.onHover != null) {
            this.onHover.putInside(null);
        }
        Pane oldHover = this.onHover;
        this.onHover = hoverPane;
        if (this.onHover != null) {
            this.onHover.putInside(this.window);
        }
        return oldHover;
    }

    public Pane getHoverPane() {
        return this.onHover;
    }

    @Deprecated
    protected int drawString(MatrixStack ms, String text, float x, float y, int color, boolean shadow) {
        if (shadow) {
            return this.mc.field_71466_p.func_238405_a_(ms, text, x, y, color);
        }
        return this.mc.field_71466_p.func_238421_b_(ms, text, x, y, color);
    }

    protected int drawString(MatrixStack ms, ITextComponent text, float x, float y, int color, boolean shadow) {
        if (shadow) {
            return this.mc.field_71466_p.func_243246_a(ms, text, x, y, color);
        }
        return this.mc.field_71466_p.func_243248_b(ms, text, x, y, color);
    }

    protected int drawString(MatrixStack ms, IReorderingProcessor text, float x, float y, int color, boolean shadow) {
        if (shadow) {
            return this.mc.field_71466_p.func_238407_a_(ms, text, x, y, color);
        }
        return this.mc.field_71466_p.func_238422_b_(ms, text, x, y, color);
    }

    public boolean onMouseDrag(double mx, double my, int speed, double deltaX, double deltaY) {
        return false;
    }

    protected static void blitRepeatable(MatrixStack ms, int x, int y, int width, int height, int u, int v, int uWidth, int vHeight, int textureWidth, int textureHeight, int uRepeat, int vRepeat, int repeatWidth, int repeatHeight) {
        if (uRepeat < 0 || vRepeat < 0 || uRepeat >= uWidth || vRepeat >= vHeight || repeatWidth < 1 || repeatHeight < 1 || repeatWidth > uWidth - uRepeat || repeatHeight > vHeight - vRepeat) {
            throw new IllegalArgumentException("Repeatable box is outside of texture box");
        }
        int repeatCountX = Math.max(1, Math.max(0, width - (uWidth - repeatWidth)) / repeatWidth);
        int repeatCountY = Math.max(1, Math.max(0, height - (vHeight - repeatHeight)) / repeatHeight);
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (int i = 0; i < repeatCountX; ++i) {
            int uAdjust = i == 0 ? 0 : uRepeat;
            int xStart = x + uAdjust + i * repeatWidth;
            int w = Math.min(repeatWidth + uRepeat - uAdjust, width - (uWidth - uRepeat - repeatWidth));
            float minU = (float)(u + uAdjust) / (float)textureWidth;
            float maxU = (float)(u + uAdjust + w) / (float)textureWidth;
            for (int j = 0; j < repeatCountY; ++j) {
                int vAdjust = j == 0 ? 0 : vRepeat;
                int yStart = y + vAdjust + j * repeatHeight;
                int h = Math.min(repeatHeight + vRepeat - vAdjust, height - (vHeight - vRepeat - repeatHeight));
                float minV = (float)(v + vAdjust) / (float)textureHeight;
                float maxV = (float)(v + vAdjust + h) / (float)textureHeight;
                buffer.func_227888_a_(mat, (float)xStart, (float)(yStart + h), 0.0f).func_225583_a_(minU, maxV).func_181675_d();
                buffer.func_227888_a_(mat, (float)(xStart + w), (float)(yStart + h), 0.0f).func_225583_a_(maxU, maxV).func_181675_d();
                buffer.func_227888_a_(mat, (float)(xStart + w), (float)yStart, 0.0f).func_225583_a_(maxU, minV).func_181675_d();
                buffer.func_227888_a_(mat, (float)xStart, (float)yStart, 0.0f).func_225583_a_(minU, minV).func_181675_d();
            }
        }
        int xEnd = x + Math.min(uRepeat + repeatCountX * repeatWidth, width - (uWidth - uRepeat - repeatWidth));
        int yEnd = y + Math.min(vRepeat + repeatCountY * repeatHeight, height - (vHeight - vRepeat - repeatHeight));
        int uLeft = width - (xEnd - x);
        int vLeft = height - (yEnd - y);
        float restMinU = (float)(u + uWidth - uLeft) / (float)textureWidth;
        float restMaxU = (float)(u + uWidth) / (float)textureWidth;
        float restMinV = (float)(v + vHeight - vLeft) / (float)textureHeight;
        float restMaxV = (float)(v + vHeight) / (float)textureHeight;
        for (int i = 0; i < repeatCountX; ++i) {
            int uAdjust = i == 0 ? 0 : uRepeat;
            int xStart = x + uAdjust + i * repeatWidth;
            int w = Math.min(repeatWidth + uRepeat - uAdjust, width - uLeft);
            float minU = (float)(u + uAdjust) / (float)textureWidth;
            float maxU = (float)(u + uAdjust + w) / (float)textureWidth;
            buffer.func_227888_a_(mat, (float)xStart, (float)(yEnd + vLeft), 0.0f).func_225583_a_(minU, restMaxV).func_181675_d();
            buffer.func_227888_a_(mat, (float)(xStart + w), (float)(yEnd + vLeft), 0.0f).func_225583_a_(maxU, restMaxV).func_181675_d();
            buffer.func_227888_a_(mat, (float)(xStart + w), (float)yEnd, 0.0f).func_225583_a_(maxU, restMinV).func_181675_d();
            buffer.func_227888_a_(mat, (float)xStart, (float)yEnd, 0.0f).func_225583_a_(minU, restMinV).func_181675_d();
        }
        for (int j = 0; j < repeatCountY; ++j) {
            int vAdjust = j == 0 ? 0 : vRepeat;
            int yStart = y + vAdjust + j * repeatHeight;
            int h = Math.min(repeatHeight + vRepeat - vAdjust, height - vLeft);
            float minV = (float)(v + vAdjust) / (float)textureHeight;
            float maxV = (float)(v + vAdjust + h) / (float)textureHeight;
            buffer.func_227888_a_(mat, (float)xEnd, (float)(yStart + h), 0.0f).func_225583_a_(restMinU, maxV).func_181675_d();
            buffer.func_227888_a_(mat, (float)(xEnd + uLeft), (float)(yStart + h), 0.0f).func_225583_a_(restMaxU, maxV).func_181675_d();
            buffer.func_227888_a_(mat, (float)(xEnd + uLeft), (float)yStart, 0.0f).func_225583_a_(restMaxU, minV).func_181675_d();
            buffer.func_227888_a_(mat, (float)xEnd, (float)yStart, 0.0f).func_225583_a_(restMinU, minV).func_181675_d();
        }
        buffer.func_227888_a_(mat, (float)xEnd, (float)(yEnd + vLeft), 0.0f).func_225583_a_(restMinU, restMaxV).func_181675_d();
        buffer.func_227888_a_(mat, (float)(xEnd + uLeft), (float)(yEnd + vLeft), 0.0f).func_225583_a_(restMaxU, restMaxV).func_181675_d();
        buffer.func_227888_a_(mat, (float)(xEnd + uLeft), (float)yEnd, 0.0f).func_225583_a_(restMaxU, restMinV).func_181675_d();
        buffer.func_227888_a_(mat, (float)xEnd, (float)yEnd, 0.0f).func_225583_a_(restMinU, restMinV).func_181675_d();
        buffer.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)buffer);
    }

    static {
        debugging = false;
    }

    private static class ScissorsInfo {
        private final int xStart;
        private final int yStart;
        private final int xEnd;
        private final int yEnd;
        private final int oldGuiWidth;
        private final int oldGuiHeight;

        ScissorsInfo(int xStart, int xEnd, int yStart, int yEnd, int oldGuiWidth, int oldGuiHeight) {
            this.xStart = xStart;
            this.xEnd = xEnd;
            this.yStart = yStart;
            this.yEnd = yEnd;
            this.oldGuiWidth = oldGuiWidth;
            this.oldGuiHeight = oldGuiHeight;
        }
    }
}

